/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static final FormattingTuple format(String messagePattern, Object arg) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg});
    }

    public static final FormattingTuple format(String messagePattern, Object arg1, Object arg2) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg1, arg2});
    }

    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate(argArray);
        Object[] args2 = argArray;
        if (throwableCandidate != null) {
            args2 = MessageFormatter.trimmedCopy(argArray);
        }
        return MessageFormatter.arrayFormat(messagePattern, args2, throwableCandidate);
    }

    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray, Throwable throwable) {
        if (messagePattern == null) {
            return new FormattingTuple(null, argArray, throwable);
        }
        if (argArray == null) {
            return new FormattingTuple(messagePattern);
        }
        int i11 = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        for (int L = 0; L < argArray.length; ++L) {
            int j11 = messagePattern.indexOf(DELIM_STR, i11);
            if (j11 == -1) {
                if (i11 == 0) {
                    return new FormattingTuple(messagePattern, argArray, throwable);
                }
                sbuf.append(messagePattern, i11, messagePattern.length());
                return new FormattingTuple(sbuf.toString(), argArray, throwable);
            }
            if (MessageFormatter.isEscapedDelimeter(messagePattern, j11)) {
                if (!MessageFormatter.isDoubleEscaped(messagePattern, j11)) {
                    --L;
                    sbuf.append(messagePattern, i11, j11 - 1);
                    sbuf.append('{');
                    i11 = j11 + 1;
                    continue;
                }
                sbuf.append(messagePattern, i11, j11 - 1);
                MessageFormatter.deeplyAppendParameter(sbuf, argArray[L], new HashMap<Object[], Object>());
                i11 = j11 + 2;
                continue;
            }
            sbuf.append(messagePattern, i11, j11);
            MessageFormatter.deeplyAppendParameter(sbuf, argArray[L], new HashMap<Object[], Object>());
            i11 = j11 + 2;
        }
        sbuf.append(messagePattern, i11, messagePattern.length());
        return new FormattingTuple(sbuf.toString(), argArray, throwable);
    }

    static final boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    static final boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o11, Map<Object[], Object> seenMap) {
        if (o11 == null) {
            sbuf.append("null");
            return;
        }
        if (!o11.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(sbuf, o11);
        } else if (o11 instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o11);
        } else if (o11 instanceof byte[]) {
            MessageFormatter.byteArrayAppend(sbuf, (byte[])o11);
        } else if (o11 instanceof char[]) {
            MessageFormatter.charArrayAppend(sbuf, (char[])o11);
        } else if (o11 instanceof short[]) {
            MessageFormatter.shortArrayAppend(sbuf, (short[])o11);
        } else if (o11 instanceof int[]) {
            MessageFormatter.intArrayAppend(sbuf, (int[])o11);
        } else if (o11 instanceof long[]) {
            MessageFormatter.longArrayAppend(sbuf, (long[])o11);
        } else if (o11 instanceof float[]) {
            MessageFormatter.floatArrayAppend(sbuf, (float[])o11);
        } else if (o11 instanceof double[]) {
            MessageFormatter.doubleArrayAppend(sbuf, (double[])o11);
        } else {
            MessageFormatter.objectArrayAppend(sbuf, (Object[])o11, seenMap);
        }
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o11) {
        try {
            String oAsString = o11.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable t11) {
            Util.report("SLF4J: Failed toString() invocation on an object of type [" + o11.getClass().getName() + "]", t11);
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a11, Map<Object[], Object> seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a11)) {
            seenMap.put(a11, null);
            int len = a11.length;
            for (int i11 = 0; i11 < len; ++i11) {
                MessageFormatter.deeplyAppendParameter(sbuf, a11[i11], seenMap);
                if (i11 == len - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a11);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a11) {
        sbuf.append('[');
        int len = a11.length;
        for (int i11 = 0; i11 < len; ++i11) {
            sbuf.append(a11[i11]);
            if (i11 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a11) {
        sbuf.append('[');
        int len = a11.length;
        for (int i11 = 0; i11 < len; ++i11) {
            sbuf.append(a11[i11]);
            if (i11 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a11) {
        sbuf.append('[');
        int len = a11.length;
        for (int i11 = 0; i11 < len; ++i11) {
            sbuf.append(a11[i11]);
            if (i11 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a11) {
        sbuf.append('[');
        int len = a11.length;
        for (int i11 = 0; i11 < len; ++i11) {
            sbuf.append(a11[i11]);
            if (i11 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a11) {
        sbuf.append('[');
        int len = a11.length;
        for (int i11 = 0; i11 < len; ++i11) {
            sbuf.append(a11[i11]);
            if (i11 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a11) {
        sbuf.append('[');
        int len = a11.length;
        for (int i11 = 0; i11 < len; ++i11) {
            sbuf.append(a11[i11]);
            if (i11 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a11) {
        sbuf.append('[');
        int len = a11.length;
        for (int i11 = 0; i11 < len; ++i11) {
            sbuf.append(a11[i11]);
            if (i11 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a11) {
        sbuf.append('[');
        int len = a11.length;
        for (int i11 = 0; i11 < len; ++i11) {
            sbuf.append(a11[i11]);
            if (i11 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    public static Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object lastEntry = argArray[argArray.length - 1];
        if (lastEntry instanceof Throwable) {
            return (Throwable)lastEntry;
        }
        return null;
    }

    public static Object[] trimmedCopy(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            throw new IllegalStateException("non-sensical empty or null argument array");
        }
        int trimmedLen = argArray.length - 1;
        Object[] trimmed = new Object[trimmedLen];
        if (trimmedLen > 0) {
            System.arraycopy(argArray, 0, trimmed, 0, trimmedLen);
        }
        return trimmed;
    }
}

