/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkotlin/io/path/PathRelativizer;", "", "()V", "emptyPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "parentPath", "tryRelativeTo", "path", "base", "kotlin-stdlib-jdk7"})
final class PathRelativizer {
    @NotNull
    public static final PathRelativizer INSTANCE = new PathRelativizer();
    private static final Path emptyPath = Paths.get("", new String[0]);
    private static final Path parentPath = Paths.get("..", new String[0]);

    private PathRelativizer() {
    }

    @NotNull
    public final Path tryRelativeTo(@NotNull Path path, @NotNull Path base) {
        Path path2;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(base, "base");
        Path bn2 = base.normalize();
        Path pn2 = path.normalize();
        Path rn2 = bn2.relativize(pn2);
        int n11 = Math.min(bn2.getNameCount(), pn2.getNameCount());
        for (int i11 = 0; i11 < n11 && Intrinsics.areEqual(bn2.getName(i11), parentPath); ++i11) {
            if (Intrinsics.areEqual(pn2.getName(i11), parentPath)) continue;
            throw new IllegalArgumentException("Unable to compute relative path");
        }
        if (!Intrinsics.areEqual(pn2, bn2) && Intrinsics.areEqual(bn2, emptyPath)) {
            path2 = pn2;
        } else {
            String rnString = ((Object)rn2).toString();
            String string = rn2.getFileSystem().getSeparator();
            Intrinsics.checkNotNullExpressionValue(string, "getSeparator(...)");
            path2 = StringsKt.endsWith$default(rnString, string, false, 2, null) ? rn2.getFileSystem().getPath(StringsKt.dropLast(rnString, rn2.getFileSystem().getSeparator().length()), new String[0]) : rn2;
        }
        Path r11 = path2;
        Intrinsics.checkNotNull(r11);
        return r11;
    }
}

