/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.concurrency;

import com.android.utils.JvmWideVariable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ReadWriteProcessLock {
    private final Lock readLock = new ReadLock();
    private final Lock writeLock = new WriteLock();
    private final Path lockFile;
    private final ReentrantReadWriteLock withinProcessLock;
    private final ReentrantLock criticalSectionLock;
    private final Map<Thread, Boolean> threadToLockTypeMap;
    private final AtomicReference<FileChannel> sharedFileChannel;
    private final AtomicReference<FileLock> sharedFileLock;

    public ReadWriteProcessLock(Path lockFile) {
        try {
            lockFile = ReadWriteProcessLock.createAndNormalizeLockFile(lockFile);
        }
        catch (IOException e11) {
            throw new UncheckedIOException(e11);
        }
        this.lockFile = lockFile;
        this.withinProcessLock = JvmWideVariable.getJvmWideObjectPerKey(ReadWriteProcessLock.class, "withinProcessLock", TypeToken.of(Path.class), TypeToken.of(ReentrantReadWriteLock.class), lockFile, ReentrantReadWriteLock::new);
        this.criticalSectionLock = JvmWideVariable.getJvmWideObjectPerKey(ReadWriteProcessLock.class, "criticalSectionLock", TypeToken.of(Path.class), TypeToken.of(ReentrantLock.class), lockFile, ReentrantLock::new);
        this.threadToLockTypeMap = JvmWideVariable.getJvmWideObjectPerKey(ReadWriteProcessLock.class, "threadToLockTypeMap", TypeToken.of(Path.class), new TypeToken<Map<Thread, Boolean>>(){}, lockFile, HashMap::new);
        this.sharedFileChannel = JvmWideVariable.getJvmWideObjectPerKey(ReadWriteProcessLock.class, "sharedFileChannel", TypeToken.of(Path.class), new TypeToken<AtomicReference<FileChannel>>(){}, lockFile, AtomicReference::new);
        this.sharedFileLock = JvmWideVariable.getJvmWideObjectPerKey(ReadWriteProcessLock.class, "sharedFileLock", TypeToken.of(Path.class), new TypeToken<AtomicReference<FileLock>>(){}, lockFile, AtomicReference::new);
    }

    @VisibleForTesting
    static Path createAndNormalizeLockFile(Path lockFilePath) throws IOException {
        if (!Files.exists(lockFilePath, new LinkOption[0])) {
            lockFilePath = lockFilePath.normalize();
            Preconditions.checkArgument(Files.exists(Verify.verifyNotNull(lockFilePath.getParent()), new LinkOption[0]), "Parent directory of " + lockFilePath.toAbsolutePath() + " does not exist");
            try {
                Files.createFile(lockFilePath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        Preconditions.checkArgument(!Files.isDirectory(lockFilePath = lockFilePath.toRealPath(new LinkOption[0]), new LinkOption[0]), lockFilePath.toAbsolutePath() + " is a directory.");
        long lockFileSize = Files.size(lockFilePath);
        Preconditions.checkArgument(lockFileSize == 0L, "File '%s' with size=%s cannot be used as a lock file.", (Object)lockFilePath.toAbsolutePath(), lockFileSize);
        return lockFilePath;
    }

    public Lock readLock() {
        return this.readLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    private void acquireLock(boolean shared) throws IOException {
        java.util.concurrent.locks.Lock lock = shared ? this.withinProcessLock.readLock() : this.withinProcessLock.writeLock();
        lock.lock();
        try {
            this.acquireInterProcessLock(shared);
        }
        catch (Throwable throwable) {
            lock.unlock();
            throw throwable;
        }
    }

    private boolean tryAcquireLock(boolean shared, long nanosTimeout) throws IOException {
        boolean interProcessLockAcquired;
        Stopwatch stopwatch = Stopwatch.createStarted();
        java.util.concurrent.locks.Lock lock = shared ? this.withinProcessLock.readLock() : this.withinProcessLock.writeLock();
        try {
            if (!lock.tryLock(nanosTimeout, TimeUnit.NANOSECONDS)) {
                return false;
            }
        }
        catch (InterruptedException e11) {
            throw new RuntimeException(e11);
        }
        try {
            stopwatch.stop();
            long nanosRemainingTimeout = nanosTimeout - stopwatch.elapsed(TimeUnit.NANOSECONDS);
            interProcessLockAcquired = this.tryAcquireInterProcessLock(shared, nanosRemainingTimeout);
        }
        catch (Throwable throwable) {
            lock.unlock();
            throw throwable;
        }
        if (!interProcessLockAcquired) {
            lock.unlock();
        }
        return interProcessLockAcquired;
    }

    private void releaseLock(boolean shared) throws IOException {
        java.util.concurrent.locks.Lock lock;
        try {
            this.releaseInterProcessLock(shared);
            lock = shared ? this.withinProcessLock.readLock() : this.withinProcessLock.writeLock();
        }
        catch (Throwable throwable) {
            java.util.concurrent.locks.Lock lock2 = shared ? this.withinProcessLock.readLock() : this.withinProcessLock.writeLock();
            lock2.unlock();
            throw throwable;
        }
        lock.unlock();
    }

    private void acquireInterProcessLock(boolean shared) throws IOException {
        this.criticalSectionLock.lock();
        try {
            Preconditions.checkState(!this.threadToLockTypeMap.containsKey(Thread.currentThread()), "ReadWriteProcessLock is not reentrant, violated by thread " + Thread.currentThread());
            if (shared) {
                Preconditions.checkState(!this.threadToLockTypeMap.values().contains(false));
            } else {
                Preconditions.checkState(this.threadToLockTypeMap.isEmpty());
            }
            if (this.threadToLockTypeMap.isEmpty()) {
                this.acquireFileLock(shared);
            }
            this.threadToLockTypeMap.put(Thread.currentThread(), shared);
        }
        finally {
            this.criticalSectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAcquireInterProcessLock(boolean shared, long nanosTimeout) throws IOException {
        boolean fileLockAcquired;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            if (!this.criticalSectionLock.tryLock(nanosTimeout, TimeUnit.NANOSECONDS)) {
                return false;
            }
        }
        catch (InterruptedException e11) {
            throw new RuntimeException(e11);
        }
        try {
            Preconditions.checkState(!this.threadToLockTypeMap.containsKey(Thread.currentThread()), "ReadWriteProcessLock is not reentrant, violated by thread " + Thread.currentThread());
            if (shared) {
                Preconditions.checkState(!this.threadToLockTypeMap.values().contains(false));
            } else {
                Preconditions.checkState(this.threadToLockTypeMap.isEmpty());
            }
            if (this.threadToLockTypeMap.isEmpty()) {
                stopwatch.stop();
                long nanosRemainingTimeout = nanosTimeout - stopwatch.elapsed(TimeUnit.NANOSECONDS);
                fileLockAcquired = this.tryAcquireFileLock(shared, nanosRemainingTimeout);
            } else {
                fileLockAcquired = true;
            }
            if (fileLockAcquired) {
                this.threadToLockTypeMap.put(Thread.currentThread(), shared);
            }
        }
        finally {
            this.criticalSectionLock.unlock();
        }
        return fileLockAcquired;
    }

    private void releaseInterProcessLock(boolean shared) throws IOException {
        this.criticalSectionLock.lock();
        try {
            Preconditions.checkState(this.threadToLockTypeMap.containsKey(Thread.currentThread()));
            if (shared) {
                Preconditions.checkState(!this.threadToLockTypeMap.values().contains(false));
            } else {
                Preconditions.checkState(this.threadToLockTypeMap.size() == 1 && this.threadToLockTypeMap.containsValue(false));
            }
            this.threadToLockTypeMap.remove(Thread.currentThread());
            if (this.threadToLockTypeMap.isEmpty()) {
                this.releaseFileLock();
            }
        }
        finally {
            this.criticalSectionLock.unlock();
        }
    }

    private void acquireFileLock(boolean shared) throws IOException {
        Preconditions.checkState(this.sharedFileChannel.get() == null && this.sharedFileLock.get() == null);
        FileChannel fileChannel = FileChannel.open(this.lockFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        try {
            FileLock fileLock;
            try {
                fileLock = fileChannel.lock(0L, Long.MAX_VALUE, shared);
            }
            catch (OverlappingFileLockException e11) {
                throw new RuntimeException("Unable to acquire a file lock for " + this.lockFile.toAbsolutePath(), e11);
            }
            this.sharedFileChannel.set(fileChannel);
            this.sharedFileLock.set(fileLock);
        }
        catch (Throwable throwable) {
            fileChannel.close();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean tryAcquireFileLock(boolean shared, long nanosTimeout) throws IOException {
        block9: {
            stopwatch = Stopwatch.createStarted();
            Preconditions.checkState(this.sharedFileChannel.get() == null && this.sharedFileLock.get() == null);
            fileChannel = FileChannel.open(this.lockFile, new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE});
            try {
                maxSleepTime = nanosTimeout / 10L;
                while (true) lbl-1000:
                // 2 sources

                {
                    try {
                        fileLock = fileChannel.tryLock(0L, 0x7FFFFFFFFFFFFFFFL, shared);
                    }
                    catch (OverlappingFileLockException e) {
                        throw new RuntimeException("Unable to acquire a file lock for " + this.lockFile.toAbsolutePath(), e);
                    }
                    if (fileLock != null) {
                        this.sharedFileChannel.set(fileChannel);
                        this.sharedFileLock.set(fileLock);
                        break block9;
                    }
                    nanosRemainingTimeout = nanosTimeout - stopwatch.elapsed(TimeUnit.NANOSECONDS);
                    if (nanosRemainingTimeout <= 0L) break block9;
                    try {
                        Thread.sleep(TimeUnit.MILLISECONDS.convert(Math.min(nanosRemainingTimeout, maxSleepTime), TimeUnit.NANOSECONDS));
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                fileChannel.close();
                throw throwable;
            }
            {
                ** while (true)
            }
        }
        if (fileLock == null) {
            fileChannel.close();
        }
        return fileLock != null;
    }

    private void releaseFileLock() throws IOException {
        FileChannel fileChannel = Preconditions.checkNotNull(this.sharedFileChannel.get());
        FileLock fileLock = Preconditions.checkNotNull(this.sharedFileLock.get());
        this.sharedFileChannel.set(null);
        this.sharedFileLock.set(null);
        try {
            fileLock.release();
        }
        finally {
            fileChannel.close();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("lockFile", this.lockFile).toString();
    }

    private final class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireLock(true);
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit timeUnit) throws IOException {
            return ReadWriteProcessLock.this.tryAcquireLock(true, TimeUnit.NANOSECONDS.convert(timeout, timeUnit));
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseLock(true);
        }
    }

    public static interface Lock {
        public void lock() throws IOException;

        public boolean tryLock(long var1, TimeUnit var3) throws IOException;

        public void unlock() throws IOException;
    }

    private final class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireLock(false);
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit timeUnit) throws IOException {
            return ReadWriteProcessLock.this.tryAcquireLock(false, TimeUnit.NANOSECONDS.convert(timeout, timeUnit));
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseLock(false);
        }
    }
}

