/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.archive;

import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.manifestelements.Activity;
import com.android.tools.build.bundletool.model.manifestelements.IntentFilter;
import com.android.tools.build.bundletool.model.manifestelements.Receiver;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;

public final class ArchivedAndroidManifestUtils {
    public static final String META_DATA_KEY_ARCHIVED = "com.android.vending.archive";
    public static final int WINDOW_IS_TRANSLUCENT_RESOURCE_ID = 16842840;
    public static final int WINDOW_BACKGROUND_RESOURCE_ID = 16842836;
    public static final int SCREEN_BACKGROUND_DARK_TRANSPARENT_THEME_RESOURCE_ID = 17301673;
    public static final int HOLO_LIGHT_NO_ACTION_BAR_FULSCREEN_THEME_RESOURCE_ID = 16974065;
    public static final int BACKGROUND_DIM_ENABLED = 16843295;
    public static final String REACTIVATE_ACTIVITY_NAME = "com.google.android.archive.ReactivateActivity";
    public static final String UPDATE_BROADCAST_RECEIVER_NAME = "com.google.android.archive.UpdateBroadcastReceiver";
    public static final String MY_PACKAGE_REPLACED_ACTION_NAME = "android.intent.action.MY_PACKAGE_REPLACED";
    public static final ImmutableList<Integer> MANIFEST_ATTRIBUTES_TO_KEEP = ImmutableList.of(Integer.valueOf(16843291), Integer.valueOf(16843292), Integer.valueOf(0x101000B), Integer.valueOf(16843361), Integer.valueOf(16844108));
    public static final ImmutableList<Integer> APPLICATION_ATTRIBUTES_TO_KEEP = ImmutableList.of(Integer.valueOf(0x1010020), Integer.valueOf(16844186), Integer.valueOf(16843764), Integer.valueOf(0x1010002), Integer.valueOf(16844076), Integer.valueOf(16843762), Integer.valueOf(0x1010001), Integer.valueOf(16843891), Integer.valueOf(16844011), Integer.valueOf(16844350), Integer.valueOf(16843733), Integer.valueOf(16843734), new Integer[]{16843610});
    public static final ImmutableList<String> CHILDREN_ELEMENTS_TO_KEEP = ImmutableList.of("uses-sdk", "permission", "permission-group", "permission-tree");

    public static AndroidManifest createArchivedManifest(AndroidManifest manifest, boolean removeTvIconCloud) {
        Preconditions.checkNotNull(manifest);
        ManifestEditor editor = new ManifestEditor(ArchivedAndroidManifestUtils.createMinimalManifestTag(), BundleToolVersion.getCurrentVersion()).setPackage(manifest.getPackageName()).addMetaDataBoolean(META_DATA_KEY_ARCHIVED, true);
        MANIFEST_ATTRIBUTES_TO_KEEP.forEach(attrResourceId -> editor.copyManifestElementAndroidAttribute(manifest, (int)attrResourceId));
        if (manifest.hasApplicationElement()) {
            APPLICATION_ATTRIBUTES_TO_KEEP.forEach(attrResourceId -> editor.copyApplicationElementAndroidAttribute(manifest, (int)attrResourceId));
            if (!manifest.hasApplicationAttribute(16843391)) {
                editor.copyApplicationElementAndroidAttribute(manifest, 16843392);
            } else {
                editor.setAllowBackup(false);
            }
        }
        manifest.getMetadataElement("com.google.android.gms.version").ifPresent(editor::addApplicationChildElement);
        manifest.getUsesFeatureElement("android.hardware.type.watch").forEach(editor::addManifestChildElement);
        CHILDREN_ELEMENTS_TO_KEEP.forEach(elementName -> editor.copyChildrenElements(manifest, (String)elementName));
        if (removeTvIconCloud) {
            if (manifest.hasMainActivity()) {
                editor.addActivity(ArchivedAndroidManifestUtils.createReactivateActivity(IntentFilter.builder().addActionName("android.intent.action.MAIN").addCategoryName("android.intent.category.LAUNCHER").build()));
            }
            if (manifest.hasMainTvActivity()) {
                editor.addActivity(ArchivedAndroidManifestUtils.createReactivateActivity(IntentFilter.builder().addActionName("android.intent.action.MAIN").addCategoryName("android.intent.category.LEANBACK_LAUNCHER").build(), manifest.getIconAttribute().map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsRefId()), manifest.getRoundIconAttribute().map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsRefId())));
            }
        } else {
            editor.addActivity(ArchivedAndroidManifestUtils.createReactivateActivity(manifest));
        }
        editor.addReceiver(ArchivedAndroidManifestUtils.createUpdateBroadcastReceiver());
        ArchivedAndroidManifestUtils.addTvSupportIfRequired(editor, manifest);
        return editor.save();
    }

    private static XmlProtoNode createMinimalManifestTag() {
        return XmlProtoNode.createElementNode(XmlProtoElementBuilder.create("manifest").addNamespaceDeclaration("android", "http://schemas.android.com/apk/res/android").build());
    }

    public static AndroidManifest updateArchivedIconsAndTheme(AndroidManifest manifest, ImmutableMap<String, Integer> resourceNameToIdMap, boolean removeTvIconCloud) {
        ManifestEditor archivedManifestEditor = manifest.toEditor();
        if (manifest.getIconAttribute().isPresent() && resourceNameToIdMap.containsKey("com_android_vending_archive_application_icon")) {
            archivedManifestEditor.setIcon(resourceNameToIdMap.get("com_android_vending_archive_application_icon"));
        }
        if (manifest.getRoundIconAttribute().isPresent() && resourceNameToIdMap.containsKey("com_android_vending_archive_application_round_icon")) {
            archivedManifestEditor.setRoundIcon(resourceNameToIdMap.get("com_android_vending_archive_application_round_icon"));
        }
        if (removeTvIconCloud) {
            archivedManifestEditor.setApplicationTheme(resourceNameToIdMap.get("com_android_vending_archive_tv_theme"));
        } else {
            archivedManifestEditor.setActivityTheme(REACTIVATE_ACTIVITY_NAME, resourceNameToIdMap.getOrDefault("com_android_vending_archive_tv_theme", 0));
        }
        return archivedManifestEditor.save();
    }

    private static Activity createReactivateActivity(IntentFilter intentFilter, Optional<Integer> icon, Optional<Integer> roundIcon) {
        return ArchivedAndroidManifestUtils.getCommonActivityBuilder().setName(REACTIVATE_ACTIVITY_NAME).setIntentFilter(intentFilter).setIcon(icon).setRoundIcon(roundIcon).build();
    }

    private static Activity createReactivateActivity(IntentFilter intentFilter) {
        return ArchivedAndroidManifestUtils.getCommonActivityBuilder().setIntentFilter(intentFilter).build();
    }

    private static Activity createReactivateActivity(AndroidManifest manifest) {
        IntentFilter.Builder intentFilterBuilder = IntentFilter.builder().addActionName("android.intent.action.MAIN");
        if (manifest.hasMainActivity()) {
            intentFilterBuilder.addCategoryName("android.intent.category.LAUNCHER");
        }
        if (manifest.hasMainTvActivity()) {
            intentFilterBuilder.addCategoryName("android.intent.category.LEANBACK_LAUNCHER");
        }
        return Activity.builder().setName(REACTIVATE_ACTIVITY_NAME).setTheme(16974065).setExported(true).setExcludeFromRecents(true).setStateNotNeeded(true).setNoHistory(true).setIntentFilter(intentFilterBuilder.build()).build();
    }

    private static Activity.Builder getCommonActivityBuilder() {
        return Activity.builder().setName(REACTIVATE_ACTIVITY_NAME).setExported(true).setExcludeFromRecents(true).setStateNotNeeded(true).setNoHistory(true);
    }

    private static Receiver createUpdateBroadcastReceiver() {
        return Receiver.builder().setName(UPDATE_BROADCAST_RECEIVER_NAME).setExported(true).setIntentFilter(IntentFilter.builder().addActionName(MY_PACKAGE_REPLACED_ACTION_NAME).build()).build();
    }

    private static void addTvSupportIfRequired(ManifestEditor editor, AndroidManifest originalManifest) {
        if (!originalManifest.hasMainTvActivity()) {
            return;
        }
        editor.addUsesFeatureElement("android.software.leanback", false);
        editor.addUsesFeatureElement("android.hardware.touchscreen", false);
    }

    private ArchivedAndroidManifestUtils() {
    }
}

