/*
 * Decompiled with CFR 0.152.
 */
import com.android.zipflinger.Entry;
import com.android.zipflinger.Source;
import com.android.zipflinger.Sources;
import com.android.zipflinger.ZipArchive;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

public class ZipflingerCli {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java -jar zipflinger-cli.jar <archive.apk> <files...>");
            System.exit(1);
        }
        Path path = Paths.get(stringArray[0], new String[0]);
        List<String> list = List.of(stringArray).subList(1, stringArray.length);
        Map<String, Entry> map = ZipArchive.listEntries(path);
        try (ZipArchive zipArchive = new ZipArchive(path);){
            for (String string : list) {
                Path path2 = Paths.get(string, new String[0]);
                short s = 0;
                Entry entry = map.get(string);
                if (entry != null) {
                    s = entry.getCompressionFlag();
                    zipArchive.delete(string);
                }
                Source source = Sources.from(path2, string, (int)s);
                zipArchive.add(source);
                System.out.println("Replaced: " + string + " (compressed=" + s + ")");
            }
        }
        System.out.println("Archive updated: " + path);
    }
}

