/*
 * Decompiled with CFR 0.152.
 */
import com.android.apksig.util.RunnablesExecutor;
import com.android.signflinger.SignedApk;
import com.android.signflinger.SignedApkOptions;
import com.android.zipflinger.Zip64;
import com.android.zipflinger.ZipSource;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SignflingerCli {
    public static void main(String[] stringArray) throws Exception {
        Certificate[] certificateArray;
        Object object;
        Object object2;
        Object object3;
        if (stringArray.length < 4) {
            System.err.println("Usage: java -jar signflinger-cli.jar <path-to-folder-to-pack> <output-aab> <keystore> <alias>");
            System.err.println("Passwords must be provided via env vars or stdin prompt.");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = System.getenv("KEYSTORE_PASS");
        if (string5 == null || string5.isEmpty()) {
            object3 = System.console();
            if (object3 != null) {
                object2 = ((Console)object3).readPassword("Enter keystore password: ", new Object[0]);
                string5 = new String((char[])object2);
            } else {
                System.err.println("No KEYSTORE_PASS env var set and no console available for password input.");
                System.exit(2);
            }
        }
        if ((object3 = System.getenv("KEY_ALIAS_PASS")) == null || ((String)object3).isEmpty()) {
            object3 = string5;
        }
        try {
            object2 = KeyStore.getInstance("PKCS12");
            object = new FileInputStream(string3);
            try {
                ((KeyStore)object2).load((InputStream)object, string5.toCharArray());
            }
            finally {
                ((FileInputStream)object).close();
            }
        }
        catch (IOException iOException) {
            object2 = KeyStore.getInstance("JKS");
            certificateArray = new FileInputStream(string3);
            try {
                ((KeyStore)object2).load((InputStream)certificateArray, string5.toCharArray());
            }
            finally {
                certificateArray.close();
            }
        }
        if (!((KeyStore)object2).containsAlias(string4)) {
            System.err.println("Alias '" + string4 + "' not found in keystore.");
            System.exit(5);
        }
        if (!((KeyStore)object2).isKeyEntry(string4)) {
            System.err.println("Alias '" + string4 + "' is not a key entry (likely a trusted cert only).");
            System.exit(6);
        }
        if ((object = (PrivateKey)((KeyStore)object2).getKey(string4, ((String)object3).toCharArray())) == null) {
            System.err.println("No private key found for alias: " + string4);
            System.err.println("Check that the key password is correct.");
            System.exit(4);
        }
        if ((certificateArray = ((KeyStore)object2).getCertificateChain(string4)) == null || certificateArray.length == 0) {
            System.err.println("No certificate chain found for alias: " + string4);
            System.err.println("The keystore entry must contain a certificate chain for signing.");
            System.exit(7);
        }
        List<X509Certificate> list = Arrays.stream(certificateArray).map(certificate -> (X509Certificate)certificate).collect(Collectors.toList());
        boolean bl = string2.toLowerCase().endsWith(".aab");
        if (!bl) {
            System.err.println("Use apksigner to build and sign APK");
            System.exit(3);
        }
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        SignedApkOptions signedApkOptions = new SignedApkOptions.Builder().setName(string4).setPrivateKey((PrivateKey)object).setCertificates(list).setExecutor(SignflingerCli.createExecutor()).setV1Enabled(bl2).setV2Enabled(bl3).setV3Enabled(bl4).setMinSdkVersion(18).setV1TrustManifest(false).build();
        SignedApk signedApk = new SignedApk(new File(string2), signedApkOptions, Zip64.Policy.ALLOW);
        ArrayList<Path> arrayList = new ArrayList<Path>();
        SignflingerCli.listAllFiles(Paths.get(string, new String[0]), arrayList);
        File file = File.createTempFile("signflinger_add_", ".zip");
        try (Object object4 = new ZipOutputStream(new FileOutputStream(file));){
            for (Path path : arrayList) {
                String string6 = path.toString().substring(string.length() + 1).replace('\\', '/');
                ZipEntry zipEntry = new ZipEntry(string6);
                ((ZipOutputStream)object4).putNextEntry(zipEntry);
                Files.copy(path, (OutputStream)object4);
                ((ZipOutputStream)object4).closeEntry();
            }
        }
        object4 = ZipSource.selectAll(file.toPath());
        signedApk.add((ZipSource)object4);
        file.delete();
        signedApk.close();
    }

    private static void listAllFiles(Path path, List<Path> list) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    SignflingerCli.listAllFiles(path2, list);
                    continue;
                }
                list.add(path2);
            }
        }
    }

    public static RunnablesExecutor createExecutor() {
        return runnablesProvider -> {
            ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
            int n = forkJoinPool.getParallelism();
            ArrayList<Future> arrayList = new ArrayList<Future>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(forkJoinPool.submit(runnablesProvider.createRunnable()));
            }
            try {
                for (Future future : arrayList) {
                    future.get();
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(exception);
            }
        };
    }
}

