/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction3rms;
import com.android.tools.smali.dexlib2.immutable.instruction.ImmutableInstruction;
import com.android.tools.smali.dexlib2.util.Preconditions;

public final class ImmutableInstruction3rms
extends ImmutableInstruction
implements Instruction3rms {
    public final int startRegister;
    public final int registerCount;
    public final int vtableIndex;

    public ImmutableInstruction3rms(Opcode object, int n, int n2, int n3) {
        super((Opcode)((Object)object));
        this.startRegister = Preconditions.checkShortRegister(n);
        this.registerCount = Preconditions.checkRegisterRangeCount(n2);
        if (n3 >= 0 && n3 <= 65535) {
            this.vtableIndex = n3;
            return;
        }
        object = n3;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        throw new IllegalArgumentException(String.format("Invalid vtable index: %d. Must be between 0 and 65535, inclusive", objectArray2));
    }

    @Override
    public final int getStartRegister() {
        return this.startRegister;
    }

    @Override
    public final int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public final int getVtableIndex() {
        return this.vtableIndex;
    }

    @Override
    public final Format getFormat() {
        return Format.Format3rms;
    }
}

