/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import android.util.TypedValue;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFindFrameworkResException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.axml.NamespaceStack;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.decoder.StringBlock;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.xmlpull.v1.XmlPullParser;

public class AXmlResourceParser
implements XmlPullParser {
    public static final Logger LOGGER = Logger.getLogger(AXmlResourceParser.class.getName());
    public final ResTable mResTable;
    public final NamespaceStack mNamespaces;
    public boolean mIsOperational;
    public ExtDataInputStream mIn;
    public StringBlock mStringBlock;
    public int[] mResourceIds;
    public boolean mDecreaseDepth;
    public AndrolibException mFirstError;
    public int mEvent;
    public int mLineNumber;
    public int mNameIndex;
    public int mNamespaceIndex;
    public int[] mAttributes;

    public final int getAttributeOffset(int n) {
        if (this.mEvent == 2) {
            int n2 = n * 5;
            if (n2 < this.mAttributes.length) {
                return n2;
            }
            throw new IndexOutOfBoundsException("Invalid attribute index (" + n + ").");
        }
        throw new IndexOutOfBoundsException("Current event is not START_TAG.");
    }

    public final void doNext() {
        block30: {
            int n;
            if (((AXmlResourceParser)((Object)l)).mStringBlock == null) {
                ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                ((AXmlResourceParser)((Object)l)).mStringBlock = StringBlock.readWithChunk(((AXmlResourceParser)((Object)l)).mIn);
                ((AXmlResourceParser)((Object)l)).mNamespaces.increaseDepth();
                ((AXmlResourceParser)((Object)l)).mIsOperational = true;
            }
            if ((n = ((AXmlResourceParser)((Object)l)).mEvent) == 1) {
                return;
            }
            ((AXmlResourceParser)((Object)l)).mEvent = -1;
            ((AXmlResourceParser)((Object)l)).mLineNumber = -1;
            ((AXmlResourceParser)((Object)l)).mNameIndex = -1;
            ((AXmlResourceParser)((Object)l)).mNamespaceIndex = -1;
            ((AXmlResourceParser)((Object)l)).mAttributes = null;
            while (true) {
                int n2;
                int n3;
                int n4;
                NamespaceStack namespaceStack;
                if (((AXmlResourceParser)((Object)l)).mDecreaseDepth) {
                    ((AXmlResourceParser)((Object)l)).mDecreaseDepth = false;
                    namespaceStack = ((AXmlResourceParser)((Object)l)).mNamespaces;
                    n4 = namespaceStack.mDataLength;
                    if (n4 != 0) {
                        n3 = n4 - 1;
                        n3 = namespaceStack.mData[n3];
                        if (n4 - 2 - (n3 *= 2) != 0) {
                            namespaceStack.mDataLength = n4 - (n3 + 2);
                            --namespaceStack.mDepth;
                        }
                    }
                }
                if (n == 3) {
                    namespaceStack = ((AXmlResourceParser)((Object)l)).mNamespaces;
                    if (namespaceStack.mDepth == 1) {
                        int n5;
                        n4 = namespaceStack.mDataLength;
                        if (n4 == 0) {
                            n5 = 0;
                        } else {
                            int n6 = n4 - 1;
                            n5 = namespaceStack.mData[n6];
                        }
                        if (n5 == 0) {
                            ((AXmlResourceParser)((Object)l)).mEvent = 1;
                            break block30;
                        }
                    }
                }
                if (((InputStream)((AXmlResourceParser)((Object)l)).mIn).available() == 0) {
                    Long l = ((AXmlResourceParser)((Object)l)).mIn.mCountIn.count;
                    LOGGER.warning(String.format("AXML hit unexpected end of file at byte: 0x%X", l));
                    ((AXmlResourceParser)((Object)l)).mEvent = 1;
                    break block30;
                }
                int n7 = 0;
                if (n == 0) {
                    n4 = 258;
                } else {
                    n4 = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readShort();
                    n7 = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readShort();
                }
                if (n4 == 384) {
                    n7 = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                    if (n7 >= 8 && n7 % 4 == 0) {
                        ((AXmlResourceParser)((Object)l)).mResourceIds = ((AXmlResourceParser)((Object)l)).mIn.readIntArray(n7 / 4 - 2);
                        continue;
                    }
                    throw new IOException("Invalid resource ids size (" + n7 + ").");
                }
                if (n4 < 256 || n4 > 383) break;
                if (n4 == 258 && n == -1) {
                    ((AXmlResourceParser)((Object)l)).mEvent = 0;
                    break block30;
                }
                ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                ((AXmlResourceParser)((Object)l)).mLineNumber = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                if (n4 != 256 && n4 != 257) {
                    if (n4 == 258) {
                        ((AXmlResourceParser)((Object)l)).mNamespaceIndex = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)l)).mNameIndex = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readShort();
                        n = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readShort();
                        n7 = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readShort();
                        ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readShort();
                        ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readShort();
                        ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readShort();
                        ((AXmlResourceParser)((Object)l)).mAttributes = ((AXmlResourceParser)((Object)l)).mIn.readIntArray(n7 * 5);
                        n4 = 3;
                        while (true) {
                            int[] nArray = ((AXmlResourceParser)((Object)l)).mAttributes;
                            if (n4 >= ((AXmlResourceParser)((Object)l)).mAttributes.length) break;
                            nArray[n4] = nArray[n4] >>> 24;
                            n4 += 5;
                        }
                        n4 = n7 * 20;
                        if (n4 < (n *= n7)) {
                            ((AXmlResourceParser)((Object)l)).mIn.skipBytes(n -= n4);
                            LOGGER.fine("Skipping " + n + " unknown bytes in attributes area.");
                        }
                        ((AXmlResourceParser)((Object)l)).mNamespaces.increaseDepth();
                        ((AXmlResourceParser)((Object)l)).mEvent = 2;
                    } else if (n4 == 259) {
                        ((AXmlResourceParser)((Object)l)).mNamespaceIndex = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)l)).mNameIndex = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)l)).mEvent = 3;
                        ((AXmlResourceParser)((Object)l)).mDecreaseDepth = true;
                    } else {
                        if (n4 != 260) continue;
                        ((AXmlResourceParser)((Object)l)).mNameIndex = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)l)).mEvent = 4;
                    }
                    break block30;
                }
                if (n4 == 256) {
                    n4 = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                    n3 = ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                    NamespaceStack namespaceStack2 = ((AXmlResourceParser)((Object)l)).mNamespaces;
                    if (namespaceStack2.mDepth == 0) {
                        namespaceStack2.increaseDepth();
                    }
                    int[] nArray = namespaceStack2.mData;
                    int n8 = namespaceStack2.mDataLength;
                    int n9 = namespaceStack2.mData.length - n8;
                    if (n9 <= 2) {
                        nArray = new int[(nArray.length + n9) * 2];
                        System.arraycopy(nArray, 0, nArray, 0, n8);
                        namespaceStack2.mData = nArray;
                    }
                    int n10 = namespaceStack2.mDataLength;
                    n2 = n10 - 1;
                    int[] nArray2 = namespaceStack2.mData;
                    int n11 = n4;
                    n4 = nArray2[n2];
                    nArray2[n10 - 2 - n4 * 2] = ++n4;
                    nArray2[n2] = n11;
                    nArray2[n10] = n3;
                    namespaceStack2.mData[n10 - -1] = n4;
                    namespaceStack2.mDataLength = n10 + 2;
                } else {
                    ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                    ((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt();
                    NamespaceStack namespaceStack3 = ((AXmlResourceParser)((Object)l)).mNamespaces;
                    n3 = namespaceStack3.mDataLength;
                    if (n3 != 0) {
                        n2 = n3 - 1;
                        int[] nArray = namespaceStack3.mData;
                        if ((n2 = namespaceStack3.mData[n2]) != 0) {
                            int n12 = n3;
                            int n13 = n2 + -1;
                            nArray[n3 -= 3] = n13;
                            nArray[n3 - (n13 * 2 + 1)] = n13;
                            namespaceStack3.mDataLength = n12 - 2;
                        }
                    }
                }
                if (n7 <= 16) continue;
                Integer n14 = n7 -= 16;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n14;
                LOGGER.warning(String.format("AXML header larger than 0x10 bytes, skipping %d bytes.", objectArray2));
                ((AXmlResourceParser)((Object)l)).mIn.skipBytes(n7);
            }
            ((AXmlResourceParser)((Object)l)).mIn.skipBytes(((AXmlResourceParser)((Object)l)).mIn.mDelegate.readInt() - 8);
            Long l = ((AXmlResourceParser)((Object)l)).mIn.mCountIn.count;
            LOGGER.warning(String.format("Unknown chunk type at: (0x%08x) skipping...", l));
        }
    }

    public final String getName() {
        int n;
        int n2 = this.mNameIndex;
        if (n2 != -1 && ((n = this.mEvent) == 2 || n == 3)) {
            return this.mStringBlock.getString(n2);
        }
        return null;
    }

    public final String getText() {
        int n = this.mNameIndex;
        if (n != -1 && this.mEvent == 4) {
            return this.mStringBlock.getString(n);
        }
        return null;
    }

    public final int getNamespaceCount(int n) {
        int n2;
        NamespaceStack namespaceStack = ((AXmlResourceParser)((Object)namespaceStack)).mNamespaces;
        if (namespaceStack.mDataLength != 0 && n >= 0) {
            n2 = namespaceStack.mDepth;
            if (n > n2) {
                n = n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n != 0) {
                int n4 = namespaceStack.mData[n3];
                n2 += n4;
                n3 = n4 * 2 + 2 + n3;
                --n;
            }
        } else {
            n2 = 0;
        }
        return n2;
    }

    public final String getAttributeNamespace(int n) {
        ResID resID;
        AXmlResourceParser aXmlResourceParser = this;
        int n2 = aXmlResourceParser.getAttributeOffset(n);
        int n3 = aXmlResourceParser.mAttributes[n2];
        ResID resID2 = resID;
        resID = new ResID(this.getAttributeNameResource(n));
        if (n3 == -1) {
            n = resID2.mId >> 24 & 0xFF;
            if (n == 0) {
                n = 2;
            }
            if (n == 1) {
                return "http://schemas.android.com/apk/res/android";
            }
        }
        if (n3 == -1) {
            return "";
        }
        String string = this.mStringBlock.getString(n3);
        if (string != null && !string.isEmpty()) {
            return string;
        }
        int n4 = resID2.mId >> 24 & 0xFF;
        if (n4 == 0) {
            n4 = 2;
        }
        if (n4 == 127) {
            return this.mStringBlock.getString(this.mNamespaces.get(n2, true)) == null ? "http://schemas.android.com/apk/res-auto" : this.mStringBlock.getString(this.mNamespaces.get(n2, false));
        }
        return "http://schemas.android.com/apk/res/android";
    }

    public final String decodeFromResourceId(int n) {
        if (n != 0) {
            try {
                return StringUtils.replace(this.mResTable.getResSpec((int)n).mName, "\"", "q");
            }
            catch (CantFindFrameworkResException cantFindFrameworkResException) {
            }
            catch (UndefinedResObjectException undefinedResObjectException) {}
        }
        return null;
    }

    public final String getAttributeName(int n) {
        String string;
        AXmlResourceParser aXmlResourceParser = string2;
        int n2 = aXmlResourceParser.getAttributeOffset(n);
        if ((n2 = aXmlResourceParser.mAttributes[n2 + 1]) == -1) {
            return "";
        }
        AXmlResourceParser aXmlResourceParser2 = string2;
        String string2 = ((AXmlResourceParser)((Object)string2)).mStringBlock.getString(n2);
        n = aXmlResourceParser2.getAttributeNameResource(n);
        try {
            string = aXmlResourceParser2.decodeFromResourceId(n);
        }
        catch (AndrolibException androlibException) {
            string = null;
        }
        if (string != null) {
            return string;
        }
        if (string2 != null) {
            return string2;
        }
        return "APKTOOL_MISSING_" + Integer.toHexString(n);
    }

    public final int getAttributeNameResource(int n) {
        AXmlResourceParser aXmlResourceParser = this;
        int n2 = aXmlResourceParser.getAttributeOffset(n);
        n2 = aXmlResourceParser.mAttributes[n2 + 1];
        int[] nArray = aXmlResourceParser.mResourceIds;
        if (aXmlResourceParser.mResourceIds != null && n2 >= 0 && n2 < nArray.length) {
            return nArray[n2];
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAttributeValue(int var1_1) {
        block27: {
            block28: {
                v0 = this;
                var2_3 = v0.getAttributeOffset(var1_1);
                var3_4 = v0.mAttributes;
                v1 = var2_3;
                v2 = var2_3;
                var2_3 = var3_4[var2_3 + 3];
                var3_5 = var3_4[v2 + 4];
                var4_6 = v0.mAttributes[v1 + 2];
                if (var4_6 == -1) ** GOTO lbl13
                try {
                    block29: {
                        var4_7 = ResXmlEncoders.escapeXmlChars(this.mStringBlock.getString(var4_6));
                        break block29;
lbl13:
                        // 1 sources

                        var4_7 = null;
                    }
                    var5_9 = null;
                    if (var2_3 == 1 || var2_3 == 7 || var2_3 == 2 || var2_3 == 8) {
                        var5_9 = this.decodeFromResourceId(var3_5);
                    }
                    if (var4_7 != null && var5_9 != null) {
                        var6_13 = var4_7.lastIndexOf("/");
                    }
                    ** GOTO lbl32
                }
                catch (AndrolibException var4_8) {
                    break block27;
                }
                var7_16 = var4_7.lastIndexOf(":");
                if (var6_13 == -1) ** GOTO lbl30
                if (var7_16 != -1) ** GOTO lbl32
                var4_7 = var4_7.substring(0, var6_13);
                {
                    block30: {
                        var4_7 = (String)var4_7 + "/" + var5_9;
                        break block30;
lbl30:
                        // 1 sources

                        if (!var4_7.equals(var5_9)) {
                            var4_7 = var5_9;
                        }
                    }
                    var5_10 = this.getAttributeNameResource(var1_1);
                }
                var4_7 = this.mResTable.getCurrentResPackage().getValueFactory().factory((String)var4_7, var2_3, var3_5);
                var6_14 = null;
                if (var5_10 <= 0) break block28;
                {
                    var5_11 = this.mResTable.getResSpec(var5_10);
                }
                var7_17 = v3;
                {
                    v3 = new ResConfigFlags();
                    var8_19 = (ResResource)var5_11.mResources.get(var7_17);
                    if (var8_19 == null) ** GOTO lbl-1000
                }
                {
                    var6_14 = ((ResAttr)var8_19.mValue).convertToResXmlFormat((ResScalarValue)var4_7);
                    break block28;
                }
lbl-1000:
                // 1 sources

                {
                    v4 = v5;
                    v6 = v5;
                }
                var8_19 = v7;
                {
                    v8 = var7_17;
                    v9 = var8_19;
                    v10 = v9;
                    var8_19("resource: spec=");
                    v9.append(var5_11);
                }
                {
                    v10.append(", config=");
                }
                {
                    v7.append(v8);
                }
                {
                    v4(v7.toString());
                    throw v6;
                }
            }
            if (var6_14 == null) return var4_7.encodeAsResXmlAttr();
            return var6_14;
        }
        if (this.mFirstError == null) {
            this.mFirstError = var4_8;
        }
        v11 = this;
        var5_12 = AXmlResourceParser.LOGGER;
        var6_15 = Level.WARNING;
        var7_18 = "Could not decode attr value, using undecoded value instead: ns=%s, name=%s, value=0x%08x";
        var8_20 = v11.getAttributeOffset(var1_1);
        var8_20 = v11.mAttributes[var8_20];
        var9_22 = v11.mNamespaces;
        var10_23 = var9_22.mDataLength;
        if (var10_23 == 0) {
            while (true) {
                var8_20 = -1;
                break;
            }
        } else {
            --var10_23;
            var11_24 = var9_22.mDepth;
            block18: while (true) {
                if (var11_24 == 0) ** continue;
                var12_25 = var9_22.mData[var10_23];
                var10_23 -= 2;
                while (var12_25 != 0) {
                    var13_26 = var9_22.mData;
                    if (var9_22.mData[var10_23 + 1] == var8_20) {
                        var8_20 = var13_26[var10_23];
                        break block18;
                    }
                    var10_23 -= 2;
                    --var12_25;
                }
                --var11_24;
            }
        }
        var8_21 = var8_20 == -1 ? "" : this.mStringBlock.getString(var8_20);
        this = this.getAttributeName(var1_1);
        var1_2 = var3_5;
        var5_12.log(var6_15, String.format(var7_18, new Object[]{var8_21, this, var1_2}), var4_8);
        return TypedValue.coerceToString(var2_3, var3_5);
    }

    public AXmlResourceParser(ResTable resTable) {
        NamespaceStack namespaceStack;
        ((AXmlResourceParser)((Object)namespaceStack2)).mResTable = resTable;
        NamespaceStack namespaceStack2 = namespaceStack;
        namespaceStack = new NamespaceStack();
        v1.mNamespaces = namespaceStack2;
        v1.mEvent = -1;
        v1.mLineNumber = -1;
        v1.mNameIndex = -1;
        v1.mNamespaceIndex = -1;
        v1.mAttributes = null;
    }
}

