/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8wrappers;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.ParseFlagInfo;
import com.android.tools.r8.ParseFlagPrinter;
import com.android.tools.r8.R8;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.Version;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8wrappers.utils.DepsFileWriter;
import com.android.tools.r8wrappers.utils.WrapperDiagnosticsHandler;
import com.android.tools.r8wrappers.utils.WrapperFlag;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class R8Wrapper {
    private static final String WRAPPER_STRING = "r8-aosp-wrapper";
    private static final Origin CLI_ORIGIN = new Origin(Origin.root()){

        @Override
        public String part() {
            return R8Wrapper.WRAPPER_STRING;
        }
    };
    private WrapperDiagnosticsHandler diagnosticsHandler = new WrapperDiagnosticsHandler();
    private boolean useCompatPg = false;
    private Path depsOutput = null;
    private final List<String> pgRules = new ArrayList<String>();
    private boolean printInfoDiagnostics = false;

    private static List<ParseFlagInfo> getAdditionalFlagsInfo() {
        return Arrays.asList(new WrapperFlag("--deps-file <file>", "Write input dependencies to <file>."), new WrapperFlag("--info", "Print the info-level log messages from the compiler."));
    }

    private static String getUsageMessage() {
        StringBuilder builder = R8Wrapper.appendLines(new StringBuilder(), "Usage: r8 [options] [@<argfile>] <input-files>", " where <input-files> are any combination of class, zip, or jar files", " and each <argfile> is a file containing additional arguments (one per line)", " and options are:");
        new ParseFlagPrinter().addFlags(R8Command.getParseFlagsInformation()).addFlags(R8Wrapper.getAdditionalFlagsInfo()).setIndent(2).appendLinesToBuilder(builder);
        return builder.toString();
    }

    private static StringBuilder appendLines(StringBuilder builder, String ... lines) {
        for (String line : lines) {
            builder.append(line).append(System.lineSeparator());
        }
        return builder;
    }

    public static void main(String[] args) throws CompilationFailedException {
        R8Wrapper wrapper = new R8Wrapper();
        String[] remainingArgs = wrapper.parseWrapperArguments(args);
        R8Command.Builder builder = R8Command.parse(remainingArgs, CLI_ORIGIN, wrapper.diagnosticsHandler);
        if (builder.isPrintHelp()) {
            System.out.println(R8Wrapper.getUsageMessage());
            return;
        }
        if (builder.isPrintVersion()) {
            System.out.println("R8(r8-aosp-wrapper) " + Version.getVersionString());
            return;
        }
        wrapper.applyWrapperArguments(builder);
        builder.setEnableExperimentalKeepAnnotations(true);
        if (!builder.getAndroidPlatformBuild()) {
            System.setProperty("com.android.tools.r8.disableApiModeling", "1");
        }
        System.setProperty("com.android.tools.r8.disableEnqueuerDeferredTracing", "1");
        System.setProperty("com.android.tools.r8.enableSameFilePolicy", "1");
        R8.run((R8Command)builder.build());
    }

    private String[] parseWrapperArguments(String[] args) {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        block24: for (int i11 = 0; i11 < args.length; ++i11) {
            String arg;
            switch (arg = args[i11]) {
                case "--info": {
                    this.printInfoDiagnostics = true;
                    continue block24;
                }
                case "--deps-file": {
                    String nextArg = args[++i11];
                    this.depsOutput = Paths.get(nextArg, new String[0]);
                    continue block24;
                }
                case "--multi-dex": {
                    continue block24;
                }
                case "--force-proguard-compatibility": {
                    this.useCompatPg = true;
                    continue block24;
                }
                case "-dontshrink": 
                case "-dontoptimize": 
                case "-dontobfuscate": 
                case "-ignorewarnings": {
                    this.pgRules.add(arg);
                    continue block24;
                }
                case "-injars": 
                case "-libraryjars": 
                case "-include": 
                case "-printmapping": 
                case "-printconfiguration": 
                case "-printusage": {
                    this.pgRules.add(arg + " " + args[++i11]);
                    continue block24;
                }
                default: {
                    remainingArgs.add(arg);
                }
            }
        }
        return remainingArgs.toArray(new String[0]);
    }

    private void applyWrapperArguments(R8Command.Builder builder) {
        this.diagnosticsHandler.setPrintInfoDiagnostics(this.printInfoDiagnostics);
        if (this.depsOutput != null) {
            Path codeOutput = builder.getOutputPath();
            Path target = Files.isDirectory(codeOutput, new LinkOption[0]) ? codeOutput.resolve("classes.dex") : codeOutput;
            builder.setInputDependencyGraphConsumer(new DepsFileWriter(target, this.depsOutput.toString()));
        }
        if (!this.pgRules.isEmpty()) {
            builder.addProguardConfiguration(this.pgRules, CLI_ORIGIN);
        }
        if (this.useCompatPg) {
            builder.setProguardCompatibility(this.useCompatPg);
        }
        if (builder.getMinApiLevel() == 10000) {
            builder.setAndroidPlatformBuild(true);
        }
    }
}

