/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Longs;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LittleEndianDataOutputStream(OutputStream out) {
        super(new DataOutputStream(Preconditions.checkNotNull(out)));
    }

    @Override
    public void write(byte[] b11, int off, int len) throws IOException {
        this.out.write(b11, off, len);
    }

    @Override
    public void writeBoolean(boolean v11) throws IOException {
        ((DataOutputStream)this.out).writeBoolean(v11);
    }

    @Override
    public void writeByte(int v11) throws IOException {
        ((DataOutputStream)this.out).writeByte(v11);
    }

    @Override
    @Deprecated
    public void writeBytes(String s11) throws IOException {
        ((DataOutputStream)this.out).writeBytes(s11);
    }

    @Override
    public void writeChar(int v11) throws IOException {
        this.writeShort(v11);
    }

    @Override
    public void writeChars(String s11) throws IOException {
        for (int i11 = 0; i11 < s11.length(); ++i11) {
            this.writeChar(s11.charAt(i11));
        }
    }

    @Override
    public void writeDouble(double v11) throws IOException {
        this.writeLong(Double.doubleToLongBits(v11));
    }

    @Override
    public void writeFloat(float v11) throws IOException {
        this.writeInt(Float.floatToIntBits(v11));
    }

    @Override
    public void writeInt(int v11) throws IOException {
        this.out.write(0xFF & v11);
        this.out.write(0xFF & v11 >> 8);
        this.out.write(0xFF & v11 >> 16);
        this.out.write(0xFF & v11 >> 24);
    }

    @Override
    public void writeLong(long v11) throws IOException {
        byte[] bytes = Longs.toByteArray(Long.reverseBytes(v11));
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeShort(int v11) throws IOException {
        this.out.write(0xFF & v11);
        this.out.write(0xFF & v11 >> 8);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        ((DataOutputStream)this.out).writeUTF(str);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

