/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v3;

import com.android.apksig.ApkVerifier;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.RunnablesExecutor;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;

public class V3SchemeVerifier {
    private final RunnablesExecutor mExecutor;
    private final DataSource mApk;
    private final ApkUtils.ZipSections mZipSections;
    private final ApkSigningBlockUtils.Result mResult;
    private final Set<ContentDigestAlgorithm> mContentDigestsToVerify;
    private final int mMinSdkVersion;
    private final int mMaxSdkVersion;
    private final int mBlockId;
    private final OptionalInt mOptionalRotationMinSdkVersion;
    private final boolean mFullVerification;
    private ByteBuffer mApkSignatureSchemeV3Block;

    private V3SchemeVerifier(RunnablesExecutor executor, DataSource apk, ApkUtils.ZipSections zipSections, Set<ContentDigestAlgorithm> contentDigestsToVerify, ApkSigningBlockUtils.Result result, int minSdkVersion, int maxSdkVersion, int blockId, OptionalInt optionalRotationMinSdkVersion, boolean fullVerification) {
        this.mExecutor = executor;
        this.mApk = apk;
        this.mZipSections = zipSections;
        this.mContentDigestsToVerify = contentDigestsToVerify;
        this.mResult = result;
        this.mMinSdkVersion = minSdkVersion;
        this.mMaxSdkVersion = maxSdkVersion;
        this.mBlockId = blockId;
        this.mOptionalRotationMinSdkVersion = optionalRotationMinSdkVersion;
        this.mFullVerification = fullVerification;
    }

    public static ApkSigningBlockUtils.Result verify(RunnablesExecutor executor, DataSource apk, ApkUtils.ZipSections zipSections, int minSdkVersion, int maxSdkVersion) throws IOException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        return new Builder(apk, zipSections, minSdkVersion, maxSdkVersion).setRunnablesExecutor(executor).setBlockId(-262969152).build().verify();
    }

    public ApkSigningBlockUtils.Result verify() throws IOException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        if (this.mApk == null || this.mZipSections == null) {
            throw new IllegalStateException("A non-null apk and zip sections must be specified to verify an APK's v3 signatures");
        }
        SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(this.mApk, this.mZipSections, this.mBlockId, this.mResult);
        this.mApkSignatureSchemeV3Block = signatureInfo.signatureBlock;
        DataSource beforeApkSigningBlock = this.mApk.slice(0L, signatureInfo.apkSigningBlockOffset);
        DataSource centralDir = this.mApk.slice(signatureInfo.centralDirOffset, signatureInfo.eocdOffset - signatureInfo.centralDirOffset);
        ByteBuffer eocd = signatureInfo.eocd;
        this.parseSigners();
        if (this.mResult.containsErrors()) {
            return this.mResult;
        }
        ApkSigningBlockUtils.verifyIntegrity(this.mExecutor, beforeApkSigningBlock, centralDir, eocd, this.mContentDigestsToVerify, this.mResult);
        TreeMap<Integer, ApkSigningBlockUtils.Result.SignerInfo> sortedSigners = new TreeMap<Integer, ApkSigningBlockUtils.Result.SignerInfo>();
        for (ApkSigningBlockUtils.Result.SignerInfo signer : this.mResult.signers) {
            sortedSigners.put(signer.maxSdkVersion, signer);
        }
        int firstMin = 0;
        int lastMax = 0;
        int lastLineageSize = 0;
        ArrayList<SigningCertificateLineage> lineages = new ArrayList<SigningCertificateLineage>(this.mResult.signers.size());
        for (ApkSigningBlockUtils.Result.SignerInfo signer : sortedSigners.values()) {
            int currentMin = signer.minSdkVersion;
            int currentMax = signer.maxSdkVersion;
            if (firstMin == 0) {
                firstMin = currentMin;
            } else if (!(currentMin == lastMax + 1 || currentMin == lastMax && V3SchemeVerifier.signerTargetsDevRelease(signer))) {
                this.mResult.addError(ApkVerifier.Issue.V3_INCONSISTENT_SDK_VERSIONS, new Object[0]);
                break;
            }
            lastMax = currentMax;
            if (signer.signingCertificateLineage == null) continue;
            int currLineageSize = signer.signingCertificateLineage.size();
            if (currLineageSize < lastLineageSize) {
                this.mResult.addError(ApkVerifier.Issue.V3_INCONSISTENT_LINEAGES, new Object[0]);
                break;
            }
            lastLineageSize = currLineageSize;
            lineages.add(signer.signingCertificateLineage);
        }
        if (firstMin > this.mMinSdkVersion || lastMax < (this.mOptionalRotationMinSdkVersion.isPresent() ? this.mOptionalRotationMinSdkVersion.getAsInt() - 1 : this.mMaxSdkVersion)) {
            this.mResult.addError(ApkVerifier.Issue.V3_MISSING_SDK_VERSIONS, firstMin, lastMax);
        }
        try {
            this.mResult.signingCertificateLineage = SigningCertificateLineage.consolidateLineages(lineages);
        }
        catch (IllegalArgumentException e) {
            this.mResult.addError(ApkVerifier.Issue.V3_INCONSISTENT_LINEAGES, new Object[0]);
        }
        if (!this.mResult.containsErrors()) {
            this.mResult.verified = true;
        }
        return this.mResult;
    }

    public static void parseSigners(ByteBuffer apkSignatureSchemeV3Block, Set<ContentDigestAlgorithm> contentDigestsToVerify, ApkSigningBlockUtils.Result result) throws NoSuchAlgorithmException {
        try {
            new Builder(apkSignatureSchemeV3Block).setResult(result).setContentDigestsToVerify(contentDigestsToVerify).setFullVerification(false).build().parseSigners();
        }
        catch (ApkSigningBlockUtils.SignatureNotFoundException | IOException e) {
            throw new IllegalStateException("An exception was encountered when attempting to parse the signers from the provided APK Signature Scheme v3 block", e);
        }
    }

    public ApkSigningBlockUtils.Result parseSigners() throws IOException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        CertificateFactory certFactory;
        ByteBuffer signers;
        try {
            if (this.mApkSignatureSchemeV3Block == null) {
                SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(this.mApk, this.mZipSections, this.mBlockId, this.mResult);
                this.mApkSignatureSchemeV3Block = signatureInfo.signatureBlock;
            }
            signers = ApkSigningBlockUtils.getLengthPrefixedSlice(this.mApkSignatureSchemeV3Block);
        }
        catch (ApkFormatException e) {
            this.mResult.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_SIGNERS, new Object[0]);
            return this.mResult;
        }
        if (!signers.hasRemaining()) {
            this.mResult.addError(ApkVerifier.Issue.V3_SIG_NO_SIGNERS, new Object[0]);
            return this.mResult;
        }
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        int signerCount = 0;
        while (signers.hasRemaining()) {
            int signerIndex = signerCount++;
            ApkSigningBlockUtils.Result.SignerInfo signerInfo = new ApkSigningBlockUtils.Result.SignerInfo();
            signerInfo.index = signerIndex;
            this.mResult.signers.add(signerInfo);
            try {
                ByteBuffer signer = ApkSigningBlockUtils.getLengthPrefixedSlice(signers);
                this.parseSigner(signer, certFactory, signerInfo);
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                signerInfo.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_SIGNER, new Object[0]);
                return this.mResult;
            }
        }
        return this.mResult;
    }

    /*
     * WARNING - void declaration
     */
    private void parseSigner(ByteBuffer signerBlock, CertificateFactory certFactory, ApkSigningBlockUtils.Result.SignerInfo result) throws ApkFormatException, NoSuchAlgorithmException {
        byte[] certificatePublicKeyBytes;
        int signedMaxSdkVersion;
        SignatureAlgorithm signatureAlgorithm;
        ByteBuffer signedData = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        byte[] signedDataBytes = new byte[signedData.remaining()];
        signedData.get(signedDataBytes);
        signedData.flip();
        result.signedData = signedDataBytes;
        int parsedMinSdkVersion = signerBlock.getInt();
        int parsedMaxSdkVersion = signerBlock.getInt();
        result.minSdkVersion = parsedMinSdkVersion;
        result.maxSdkVersion = parsedMaxSdkVersion;
        if (parsedMinSdkVersion < 0 || parsedMinSdkVersion > parsedMaxSdkVersion) {
            result.addError(ApkVerifier.Issue.V3_SIG_INVALID_SDK_VERSIONS, parsedMinSdkVersion, parsedMaxSdkVersion);
        }
        ByteBuffer signatures = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        byte[] publicKeyBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signerBlock);
        int signatureCount = 0;
        ArrayList<ApkSigningBlockUtils.SupportedSignature> supportedSignatures = new ArrayList<ApkSigningBlockUtils.SupportedSignature>(1);
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSigningBlockUtils.getLengthPrefixedSlice(signatures);
                int sigAlgorithmId = signature.getInt();
                byte[] sigBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signature);
                result.signatures.add(new ApkSigningBlockUtils.Result.SignerInfo.Signature(sigAlgorithmId, sigBytes));
                signatureAlgorithm = SignatureAlgorithm.findById(sigAlgorithmId);
                if (signatureAlgorithm == null) {
                    result.addWarning(ApkVerifier.Issue.V3_SIG_UNKNOWN_SIG_ALGORITHM, sigAlgorithmId);
                    continue;
                }
                supportedSignatures.add(new ApkSigningBlockUtils.SupportedSignature(signatureAlgorithm, sigBytes));
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_SIGNATURE, signatureCount);
                return;
            }
        }
        if (result.signatures.isEmpty()) {
            result.addError(ApkVerifier.Issue.V3_SIG_NO_SIGNATURES, new Object[0]);
            return;
        }
        List<ApkSigningBlockUtils.SupportedSignature> signaturesToVerify = null;
        try {
            signaturesToVerify = ApkSigningBlockUtils.getSignaturesToVerify(supportedSignatures, result.minSdkVersion, result.maxSdkVersion);
        }
        catch (ApkSigningBlockUtils.NoSupportedSignaturesException e) {
            result.addError(ApkVerifier.Issue.V3_SIG_NO_SUPPORTED_SIGNATURES, new Object[0]);
            return;
        }
        for (ApkSigningBlockUtils.SupportedSignature signature : signaturesToVerify) {
            PublicKey publicKey;
            signatureAlgorithm = signature.algorithm;
            String jcaSignatureAlgorithm = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
            AlgorithmParameterSpec jcaSignatureAlgorithmParams = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
            String keyAlgorithm = signatureAlgorithm.getJcaKeyAlgorithm();
            try {
                publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            }
            catch (Exception e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_PUBLIC_KEY, e);
                return;
            }
            try {
                Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
                sig.initVerify(publicKey);
                if (jcaSignatureAlgorithmParams != null) {
                    sig.setParameter(jcaSignatureAlgorithmParams);
                }
                signedData.position(0);
                sig.update(signedData);
                byte[] sigBytes = signature.signature;
                if (!sig.verify(sigBytes)) {
                    result.addError(ApkVerifier.Issue.V3_SIG_DID_NOT_VERIFY, new Object[]{signatureAlgorithm});
                    return;
                }
                result.verifiedSignatures.put(signatureAlgorithm, sigBytes);
                this.mContentDigestsToVerify.add(signatureAlgorithm.getContentDigestAlgorithm());
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_VERIFY_EXCEPTION, new Object[]{signatureAlgorithm, e});
                return;
            }
        }
        signedData.position(0);
        ByteBuffer digests = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ByteBuffer certificates = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        int signedMinSdkVersion = signedData.getInt();
        if (signedMinSdkVersion != parsedMinSdkVersion) {
            result.addError(ApkVerifier.Issue.V3_MIN_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD, parsedMinSdkVersion, signedMinSdkVersion);
        }
        if ((signedMaxSdkVersion = signedData.getInt()) != parsedMaxSdkVersion) {
            result.addError(ApkVerifier.Issue.V3_MAX_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD, parsedMaxSdkVersion, signedMaxSdkVersion);
        }
        ByteBuffer additionalAttributes = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        int certificateIndex = -1;
        while (certificates.hasRemaining()) {
            X509Certificate certificate;
            ++certificateIndex;
            byte[] encodedCert = ApkSigningBlockUtils.readLengthPrefixedByteArray(certificates);
            try {
                certificate = X509CertificateUtils.generateCertificate(encodedCert, certFactory);
            }
            catch (CertificateException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_CERTIFICATE, certificateIndex, certificateIndex + 1, e);
                return;
            }
            certificate = new GuaranteedEncodedFormX509Certificate(certificate, encodedCert);
            result.certs.add(certificate);
        }
        if (result.certs.isEmpty()) {
            result.addError(ApkVerifier.Issue.V3_SIG_NO_CERTIFICATES, new Object[0]);
            return;
        }
        X509Certificate mainCertificate = (X509Certificate)result.certs.get(0);
        try {
            certificatePublicKeyBytes = ApkSigningBlockUtils.encodePublicKey(mainCertificate.getPublicKey());
        }
        catch (InvalidKeyException e) {
            System.out.println("Caught an exception encoding the public key: " + e);
            e.printStackTrace();
            certificatePublicKeyBytes = mainCertificate.getPublicKey().getEncoded();
        }
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            result.addError(ApkVerifier.Issue.V3_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD, ApkSigningBlockUtils.toHex(certificatePublicKeyBytes), ApkSigningBlockUtils.toHex(publicKeyBytes));
            return;
        }
        int digestCount = 0;
        while (digests.hasRemaining()) {
            ++digestCount;
            try {
                ByteBuffer digest = ApkSigningBlockUtils.getLengthPrefixedSlice(digests);
                int sigAlgorithmId = digest.getInt();
                byte[] byArray = ApkSigningBlockUtils.readLengthPrefixedByteArray(digest);
                result.contentDigests.add(new ApkSigningBlockUtils.Result.SignerInfo.ContentDigest(sigAlgorithmId, byArray));
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_DIGEST, digestCount);
                return;
            }
        }
        ArrayList<Integer> sigAlgsFromSignaturesRecord = new ArrayList<Integer>(result.signatures.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.Signature signature : result.signatures) {
            sigAlgsFromSignaturesRecord.add(signature.getAlgorithmId());
        }
        ArrayList<Integer> sigAlgsFromDigestsRecord = new ArrayList<Integer>(result.contentDigests.size());
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest digest : result.contentDigests) {
            sigAlgsFromDigestsRecord.add(digest.getSignatureAlgorithmId());
        }
        if (!sigAlgsFromSignaturesRecord.equals(sigAlgsFromDigestsRecord)) {
            result.addError(ApkVerifier.Issue.V3_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS, sigAlgsFromSignaturesRecord, sigAlgsFromDigestsRecord);
            return;
        }
        boolean bl = false;
        boolean rotationAttrFound = false;
        while (additionalAttributes.hasRemaining()) {
            void var24_42;
            ++var24_42;
            try {
                ByteBuffer attribute = ApkSigningBlockUtils.getLengthPrefixedSlice(additionalAttributes);
                int id = attribute.getInt();
                byte[] value = ByteBufferUtils.toByteArray(attribute);
                result.additionalAttributes.add(new ApkSigningBlockUtils.Result.SignerInfo.AdditionalAttribute(id, value));
                if (id == 1000370060) {
                    try {
                        result.signingCertificateLineage = SigningCertificateLineage.readFromV3AttributeValue(value);
                        SigningCertificateLineage subLineage = result.signingCertificateLineage.getSubLineage((X509Certificate)result.certs.get(0));
                        if (result.signingCertificateLineage.size() == subLineage.size()) continue;
                        result.addError(ApkVerifier.Issue.V3_SIG_POR_CERT_MISMATCH, new Object[0]);
                    }
                    catch (SecurityException e) {
                        result.addError(ApkVerifier.Issue.V3_SIG_POR_DID_NOT_VERIFY, new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        result.addError(ApkVerifier.Issue.V3_SIG_POR_CERT_MISMATCH, new Object[0]);
                    }
                    catch (Exception e) {
                        result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_LINEAGE, new Object[0]);
                    }
                    continue;
                }
                if (id == 1436519170) {
                    rotationAttrFound = true;
                    if (this.mMaxSdkVersion < 33 || !this.mFullVerification) continue;
                    int attrRotationMinSdkVersion = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    if (this.mOptionalRotationMinSdkVersion.isPresent()) {
                        int rotationMinSdkVersion = this.mOptionalRotationMinSdkVersion.getAsInt();
                        if (attrRotationMinSdkVersion == rotationMinSdkVersion) continue;
                        result.addError(ApkVerifier.Issue.V31_ROTATION_MIN_SDK_MISMATCH, attrRotationMinSdkVersion, rotationMinSdkVersion);
                        continue;
                    }
                    result.addError(ApkVerifier.Issue.V31_BLOCK_MISSING, attrRotationMinSdkVersion);
                    continue;
                }
                if (id == -1029262406) {
                    if (this.mBlockId == 462663009) continue;
                    result.addWarning(ApkVerifier.Issue.V31_ROTATION_TARGETS_DEV_RELEASE_ATTR_ON_V3_SIGNER, new Object[0]);
                    continue;
                }
                result.addWarning(ApkVerifier.Issue.V3_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE, id);
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                result.addError(ApkVerifier.Issue.V3_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE, (int)var24_42);
                return;
            }
        }
        if (this.mFullVerification && this.mOptionalRotationMinSdkVersion.isPresent() && !rotationAttrFound) {
            result.addWarning(ApkVerifier.Issue.V31_ROTATION_MIN_SDK_ATTR_MISSING, this.mOptionalRotationMinSdkVersion.getAsInt());
        }
    }

    public static boolean signerTargetsDevRelease(ApkSigningBlockUtils.Result.SignerInfo signerInfo) {
        boolean result = signerInfo.additionalAttributes.stream().mapToInt(attribute -> attribute.getId()).anyMatch(attrId -> attrId == -1029262406);
        return result;
    }

    public static class Builder {
        private RunnablesExecutor mExecutor = RunnablesExecutor.SINGLE_THREADED;
        private DataSource mApk;
        private ApkUtils.ZipSections mZipSections;
        private ByteBuffer mApkSignatureSchemeV3Block;
        private Set<ContentDigestAlgorithm> mContentDigestsToVerify;
        private ApkSigningBlockUtils.Result mResult;
        private int mMinSdkVersion;
        private int mMaxSdkVersion;
        private int mBlockId = -262969152;
        private boolean mFullVerification = true;
        private OptionalInt mOptionalRotationMinSdkVersion = OptionalInt.empty();

        public Builder(DataSource apk, ApkUtils.ZipSections zipSections, int minSdkVersion, int maxSdkVersion) {
            this.mApk = apk;
            this.mZipSections = zipSections;
            this.mMinSdkVersion = minSdkVersion;
            this.mMaxSdkVersion = maxSdkVersion;
        }

        public Builder(ByteBuffer apkSignatureSchemeV3Block) {
            this.mApkSignatureSchemeV3Block = apkSignatureSchemeV3Block;
        }

        public Builder setRunnablesExecutor(RunnablesExecutor executor) {
            this.mExecutor = executor;
            return this;
        }

        public Builder setBlockId(int blockId) {
            this.mBlockId = blockId;
            return this;
        }

        public Builder setRotationMinSdkVersion(int rotationMinSdkVersion) {
            this.mOptionalRotationMinSdkVersion = OptionalInt.of(rotationMinSdkVersion);
            return this;
        }

        public Builder setResult(ApkSigningBlockUtils.Result result) {
            this.mResult = result;
            return this;
        }

        public Builder setContentDigestsToVerify(Set<ContentDigestAlgorithm> contentDigestsToVerify) {
            this.mContentDigestsToVerify = contentDigestsToVerify;
            return this;
        }

        public Builder setFullVerification(boolean fullVerification) {
            this.mFullVerification = fullVerification;
            return this;
        }

        public V3SchemeVerifier build() {
            int sigSchemeVersion;
            switch (this.mBlockId) {
                case -262969152: {
                    sigSchemeVersion = 3;
                    this.mMinSdkVersion = Math.max(this.mMinSdkVersion, 28);
                    break;
                }
                case 462663009: {
                    sigSchemeVersion = 31;
                    this.mMinSdkVersion = this.mMaxSdkVersion;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported APK Signature Scheme V3 block ID: 0x%08x", this.mBlockId));
                }
            }
            if (this.mResult == null) {
                this.mResult = new ApkSigningBlockUtils.Result(sigSchemeVersion);
            }
            if (this.mContentDigestsToVerify == null) {
                this.mContentDigestsToVerify = new HashSet<ContentDigestAlgorithm>(1);
            }
            V3SchemeVerifier verifier = new V3SchemeVerifier(this.mExecutor, this.mApk, this.mZipSections, this.mContentDigestsToVerify, this.mResult, this.mMinSdkVersion, this.mMaxSdkVersion, this.mBlockId, this.mOptionalRotationMinSdkVersion, this.mFullVerification);
            if (this.mApkSignatureSchemeV3Block != null) {
                verifier.mApkSignatureSchemeV3Block = this.mApkSignatureSchemeV3Block;
            }
            return verifier;
        }
    }
}

